       PROGRAM VRZAHB
       
* Blame for this program resides with Peter A. Bergbusch, Dept. of Physics,
* University of Regina. 

* Last update: September 22, 2005.
       
* The INPUT FILE is in the format of a zahb*.data file produced by DAVB at
* the University of Victoria.
 
* COLOUR TRANSFORMATIONS and BOLOMETRIC CORRECTIONS      
* INPUT files BVRILO.DATA on unit 10 and BVRIHI.DATA on unit 11 are opened
* and closed inside subroutine BVRI, and files UVBYLO.DATA on unit 12 and 
* UVBYHI.DATA on unit 13 are opened and closed inside subroutine UVBY. 
* Copies of these files must be in the working directory.

*23456789012345678901234567890123456789012345678901234567890123456789012
       IMPLICIT DOUBLE PRECISION (A-H,O-Z)
       DOUBLE PRECISION LUM(50),MASS(50),TEFF(50),MBOL
       CHARACTER INFILE*60,OUTFILE*60,HLINE(7)*80

       PARAMETER (C1 = 10.60917D0)
     
* Other INPUT files, BVRILO.DATA on unit 10 and BVRIHI.DATA on unit 11, 
* are opened and closed inside subroutine BVRI. UVBYLO.DATA on unit 12 and
* UVBYHI.DATA are opened and closed inside subroutine UVBY.


       CALL IOFILE(7,'IN','FILE.DATA',.FALSE.,' ',
     1                     INFILE,.TRUE.,' Input zahb*.data File: ')
     
       CALL PARSE(INFILE,'NAME',OUTFILE,NCH)
       NCHOUT = NCH + 5
       OUTFILE(1:NCHOUT) = OUTFILE(1:NCH)//'.zahb'
       
       CALL IOFILE(8,'OUT','FILE.ZAHB',.FALSE.,' ',
     1                   OUTFILE,.FALSE.,'    Output *.zahb File: ')

       DO I = 1, 7
         READ (7,'(a)') HLINE(I)
         CALL STR_TRIM(80,HLINE(I),NCH)
         WRITE(8,'(A)') HLINE(I)(1:NCH)
       END DO
       READ (7,*)
       
       READ (HLINE(1),'(12X,I2)') NZAHB
       READ (HLINE(2),'(12X,F6.3)') FE
                            
       CALL BVRI(0,FE,G0,T0,BMV,VMR,VMI,BC)
       CALL UVBY(0,FE,G0,T0,SBY,SM1,SC1,BC)
                
*  Process one ZAHB point at a time

       WRITE(8,'(/,t12,a,t23,a,t31,A,t41,A,t50,A,6(5X,A))')
     1         'Mass','Mbol','log Te','log g','V/y','B-V','V-R',
     2         'V-I','b-y','m1',' c1'          

       SUM1 =0.0D0
       SUM2 = 0.0D0

       DO NP = 1, NZAHB

         READ(7,'(3X,F6.3,F9.6,7x,F8.6,35X,2F6.4)') 
     1            MASS(NP),LUM(NP),TEFF(NP),SH,HECM
         SUM1 = SUM1 + SH
         SUM2 = SUM2 + HECM
       END DO
       CLOSE (UNIT=7, STATUS='KEEP')
         
       SH = SUM1/NZAHB
       HECM = SUM2/NZAHB         
         
       DO NP = 1, NZAHB  
         GRAV = LOG10(MASS(NP)) - C1 + 4.0D0*TEFF(NP) - LUM(NP)
         CALL BVRI(1,FE,GRAV,TEFF(NP),BMV,VMR,VMI,BC)
         CALL UVBY(1,FE,GRAV,TEFF(NP),SBY,SM1,SC1,BC)
         MBOL = 4.75D0 - 2.5D0*LUM(NP)
         V = MBOL - BC
         WRITE(8,'(I5,F14.10,F8.4,F10.6,8F8.4)') 
     1             NP,MASS(NP),MBOL,TEFF(NP),GRAV,V,BMV,VMR,VMI,
     2               SBY,SM1,SC1    
         
       END DO
       
       CLOSE(UNIT=8,STATUS='KEEP')

       STOP
       END
